# 🐛 Shai-Hulud Worm Security Scanner v5.0

This script scans your entire development folder recursively for potential indicators of the **Shai-Hulud npm supply-chain worm** and similar compromises.

---

## 🔍 What It Does
- Fetches latest known IoCs (Indicators of Compromise) from **npm Security Advisories**
- Scans all subprojects with a `package.json`
- Checks for:
  - Known compromised npm packages
  - Packages published after **September 2025**
  - Suspicious npm scripts (postinstall / eval / curl)
  - Suspicious GitHub workflows
  - Potentially leaked tokens or API keys
- Generates:
  - Individual reports per project
  - A combined summary report
  - Risk scores per project (0–100) with level (Low/Medium/High)

---

## 📊 Risk Scoring System

| Category | Condition | Score Impact |
|-----------|------------|--------------|
| Known compromised packages | +60 |
| Suspicious new (post-Sept 2025) packages | +5 each |
| Suspicious npm scripts | +10 |
| Suspicious workflows | +10 |
| Secrets detected | +5 each (up to +25) |

**0–25 = Low**  
**26–60 = Medium**  
**61–100 = High**

---

## 🧩 How To Run

1. Save the script as `scan-shai-hulud-multi.js`
2. Run it from terminal:
   ```bash
   node scan-shai-hulud-multi.js /path/to/Development
   ```
3. Reports will be saved in:
   ```
   ./shaihulud-reports/
   ├─ report-project1-20251008T163000.json
   ├─ report-project2-20251008T163005.json
   ├─ dashboard-shaihulud.html
   ├─ dashboard-shaihulud.pdf
   └─ summary-20251008T163010.json
   ```

---

## 🧠 Output Summary Example
```json
{
  "timestamp": "2025-10-08T16:31:05Z",
  "baseDir": "/Users/you/Development",
  "totalProjects": 82,
  "results": [
    {
      "project": "/Users/you/Development/my-app",
      "risk": { "score": 45, "level": "Medium" },
      "dependencies": { "found": [], "recent": [] },
      "scripts": { "flagged": [] },
      "workflows": { "suspicious": [] },
      "secrets": { "hits": [] }
    }
  ]
}
```

---

## 🧾 Generated Files
- Individual reports → `shaihulud-reports/report-*.json`
- Combined summary → `shaihulud-reports/summary-*.json`
- HTML dashboard → `dashboard-shaihulud.html`
- PDF export → `dashboard-shaihulud.pdf`

---

## ⚠️ Notes
- The scan is **read-only**; it never modifies project files.
- You can safely delete the `.shaihulud-cache.json` to force IoC refresh.
- Works even if `node_modules` folders are removed.

---

© 2025 — Automated Security Audit Utility

## 💻 OS Compatibility

This script is **fully cross-platform**, working on macOS, Windows, and Linux.

| Component | macOS | Windows | Linux | Notes |
|------------|:------:|:--------:|:-------:|--------|
| **Node.js** | ✅ | ✅ | ✅ | Requires Node 18 or later. |
| **File system (`fs`, `path`)** | ✅ | ✅ | ✅ | Uses cross-platform-safe paths. |
| **Child process (`execSync`)** | ✅ | ⚠️ | ✅ | Needs Git installed and available in PATH for secret scanning. |
| **HTTPS fetching** | ✅ | ✅ | ✅ | Uses built-in Node.js HTTPS. |
| **Puppeteer (optional)** | ✅ | ✅ | ✅ | Works everywhere; auto-downloads Chromium. |
| **UTF-8 encoding** | ✅ | ✅ | ✅ | All report files written as UTF-8. |

### 🪟 On Windows
- Make sure **Git** is installed and available in your system PATH.  
  If Git is not available, the secret-scanning feature will be skipped automatically (no crash).  
- Run the script using **PowerShell** or **Git Bash** for best results:  
  ```bash
  node scan-shai-hulud-multi.js C:\path\to\Development
  ```

### 🍎 On macOS
- Fully supported out of the box (Git and bash/zsh are already available).  
  Example command:  
  ```bash
  node scan-shai-hulud-multi.js ~/Development
  ```

### 🐧 On Linux
- Works natively. Ensure `git` is installed for secret scanning.  
  Example command:  
  ```bash
  node scan-shai-hulud-multi.js ~/Development
  ```

### 🧩 Puppeteer PDF Generation
If Puppeteer is not installed, the script shows:
```
⚠️ PDF generation skipped — Puppeteer not installed.
   To enable PDF export, run: npm install puppeteer
```
After installing Puppeteer, the script will automatically generate the PDF report on any OS.